package cn.com.duiba.mall.center.api.remoteservice.vipgoods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.PaginationDto;
import cn.com.duiba.mall.center.api.domain.dto.vipgoods.VipGoodsConfigDto;
import cn.com.duiba.mall.center.api.domain.paramquary.vipgoods.VipGoodsPageQuery;

import java.util.List;
import java.util.Map;

/**
 * 会员商品配置
 *
 * @Author: xuwei
 * @Date: 2019/05/16 15:08
 */
@AdvancedFeignClient
public interface RemoteVipGoodsConfigService {
    /**
     * 插入
     *
     * @param record
     * @return
     */
    Long insert(VipGoodsConfigDto record);

    /**
     * 批量插入
     *
     * @param records
     * @return
     */
    List<Long> batchInsert(List<VipGoodsConfigDto> records);

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    VipGoodsConfigDto findById(Long id);

    /**
     * 根据id列表查询
     *
     * @param ids
     * @return
     */
    List<VipGoodsConfigDto> findByIds(List<Long> ids);

    /**
     * 更新
     *
     * @param record
     * @return
     */
    boolean updateById(VipGoodsConfigDto record);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    boolean deleteById(Long id);

    /**
     * 分页查询
     *
     * @param query
     * @return
     */
    PaginationDto<VipGoodsConfigDto> find4Page(VipGoodsPageQuery query);

    /**
     * 根据策略id查询
     *
     * @param strategyId
     * @return
     */
    List<VipGoodsConfigDto> findByStrategyId(Long strategyId);

    /**
     * 根据策略id列表统计
     *
     * @param strategyIds
     * @return
     */
    Map<Long, Integer> countByStrategyIds(List<Long> strategyIds);

    /**
     * 根据关联商品id查询
     *
     * @param appItemId
     * @return
     */
    VipGoodsConfigDto findByAppItemId(Long appItemId);

    /**
     * 根据关联商品id列表查询
     *
     * @param appItemIds
     * @return
     */
    List<VipGoodsConfigDto> findByAppItemIds(List<Long> appItemIds);

    /**
     * 根据关联商品id列表查询
     *
     * @param appItemIds
     * @return 关联商品id -> 会员商品配置 map
     */
    Map<Long, VipGoodsConfigDto> findByAppItemIdsWithMapping(List<Long> appItemIds);

    /**
     * 批量更新状态
     *
     * @param ids
     * @param state
     */
    int batchUpdateState(List<Long> ids, int state);

    /**
     * 批量更新可兑换等级
     *
     * @param ids
     * @param grades
     */
    int batchUpdateGrades(List<Long> ids, Long grades);

    /**
     * 批量删除
     *
     * @param ids
     */
    int batchDelete(List<Long> ids);

    /**
     * 统计app有效商品个数
     * @param appId
     * @return
     */
    int countValidByAppId(Long appId);
}