package cn.com.duiba.mall.center.api.domain.dto.vipgoods;

import cn.com.duiba.mall.center.api.domain.enums.vipgoods.VipGoodsSwitchEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * 会员商品配置
 *
 * @Author: xuwei
 * @Date: 2019/05/16 14:55
 */
public class VipGoodsConfigDto implements Serializable {
    private static final long serialVersionUID = -7169236666662517132L;

    /**
     * ID
     */
    private Long id;

    /**
     * 开发者商品id
     */
    private Long appItemId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 策略id，关联了策略时才有
     */
    private Long strategyId = 0L;

    /**
     * 限购类型 0:永久 1:每天 2:限购一次
     */
    private Integer limitScope;

    /**
     * 限购数量/天数，json格式（key:等级数值 value:数量/天数）
     */
    private String limitCount;

    /**
     * 无法兑换处理:0:隐藏 1:引导用户会员转化
     */
    private Integer doMethod;

    /**
     * 升级引导页链接
     */
    private String ruleUrl;

    /**
     * 可兑换的等级（便于查询过滤）
     */
    private Long grades = 0L;

    /**
     * 状态 0:无效 1:有效
     */
    private Integer state = 0;

    /**
     * 开关位
     */
    private Long switches = 0L;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 开启开关
     *
     * @param switchEnum
     */
    public void openSwitch(VipGoodsSwitchEnum switchEnum) {
        switches |= (1 << switchEnum.getBit());
    }

    /**
     * 关闭开关
     *
     * @param switchEnum
     */
    public void closeSwitch(VipGoodsSwitchEnum switchEnum) {
        switches &= ((1 << switchEnum.getBit()) ^ ~0);
    }

    /**
     * 是否开启开关
     *
     * @param switchEnum
     * @return
     */
    public boolean hasSwitch(VipGoodsSwitchEnum switchEnum) {
        return (switches & (1 << switchEnum.getBit())) > 0;
    }

    /**
     * 是否包含指定等级
     *
     * @param grade
     * @return
     */
    public boolean containGrade(int grade) {
        return (grades & (1 << grade)) != 0;
    }

    /**
     * 是否策略商品
     *
     * @return
     */
    public boolean isStrategy() {
        return strategyId != 0;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getStrategyId() {
        return strategyId;
    }

    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    public Integer getLimitScope() {
        return limitScope;
    }

    public void setLimitScope(Integer limitScope) {
        this.limitScope = limitScope;
    }

    public String getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(String limitCount) {
        this.limitCount = limitCount == null ? null : limitCount.trim();
    }

    public Integer getDoMethod() {
        return doMethod;
    }

    public void setDoMethod(Integer doMethod) {
        this.doMethod = doMethod;
    }

    public String getRuleUrl() {
        return ruleUrl;
    }

    public void setRuleUrl(String ruleUrl) {
        this.ruleUrl = ruleUrl == null ? null : ruleUrl.trim();
    }

    public Long getGrades() {
        return grades;
    }

    public void setGrades(Long grades) {
        this.grades = grades;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Long getSwitches() {
        return switches;
    }

    public void setSwitches(Long switches) {
        this.switches = switches;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}