package cn.com.duiba.cloud.manage.service.api.remoteservice.app;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.AppAuthDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.TenantAuthDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAppAuthQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAppMenuParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteTenantAuthParam;

/**
 * 权限信息
 * @author jiangyesheng
 * @date 2021-11-10
 */
@AdvancedFeignClient
public interface RemoteAuthorityService {

    /**
     * 查询租户所有权限
     * @param authParam
     * @return
     * @throws BizException
     */
    public TenantAuthDTO tenantAuth(RemoteTenantAuthParam authParam) throws BizException;

    /**
     * 查询应用下的权限
     * @param authParam
     * @return
     * @throws BizException
     */
    public AppAuthDTO appAuth(RemoteAppAuthQueryParam authParam) throws BizException;

    /**
     * 查询应用下的菜单
     * @param menuParam
     * @return
     * @throws BizException
     */
    public AppAuthDTO appMenu(RemoteAppMenuParam menuParam) throws BizException;

}
