package cn.com.duiba.cloud.manage.service.api.model.dto.importdata;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 文件上传信息
 *
 * @Author: jiangyesheng
 * @Date: 2021/11/1
 */
@Getter
@Setter
public class FileImportDTO implements Serializable {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 租户id
     */
    private Long tenantId;

    /**
     * 导入文件url
     */
    private String importFileUrl;

    /**
     * 导入总行数量
     */
    private Integer totalNum;

    /**
     * 导入成功数量
     */
    private Integer successNum = 0;

    /**
     * 导入失败数量
     */
    private Integer failNum = 0;

    /**
     * 导入失败文件url
     */
    private String failFileUrl;

    /**
     * 导入状态 0-处理中 1-处理完毕
     */
    private String state;

}
