package cn.com.duiba.cloud.manage.service.api.remoteservice.app;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.AppAuthDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.AuthorityDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.TenantAuthDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAppAuthQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAuthDetailParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAppMenuParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAuthDeleteParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAuthRenameParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAuthSaveParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAuthSortUpdateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAuthUpdateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteTenantAuthParam;

/**
 * 权限信息
 * @author jiangyesheng
 * @date 2021-11-10
 */
@AdvancedFeignClient
public interface RemoteAuthorityService {

    /**
     * 查询租户所有权限
     * @param authParam
     * @return
     * @throws BizException
     */
    public TenantAuthDTO tenantAuth(RemoteTenantAuthParam authParam) throws BizException;

    /**
     * 查询应用下的菜单
     * @param menuParam
     * @return
     * @throws BizException
     */
    public AppAuthDTO appMenu(RemoteAppMenuParam menuParam) throws BizException;

    /**
     * 查询应用下的权限
     * @param authParam
     * @return
     * @throws BizException
     */
    public AppAuthDTO appAuth(RemoteAppAuthQueryParam authParam) throws BizException;

    /**
     * 权限重命名
     * @param param
     * @throws BizException
     */
    public void authRename(RemoteAuthRenameParam param) throws BizException;

    /**
     * 权限更新
     * @param param
     * @throws BizException
     */
    public void authUpdate(RemoteAuthUpdateParam param) throws BizException;

    /**
     * 权限保存
     * @param param
     * @throws BizException
     */
    public void authSave(RemoteAuthSaveParam param) throws BizException;

    /**
     * 删除权限
     * @param param
     * @throws BizException
     */
    public void authDelete(RemoteAuthDeleteParam param) throws BizException;

    /**
     * 更新权限排序
     * @param param
     * @throws BizException
     */
    public void authSortUpdate(RemoteAuthSortUpdateParam param) throws BizException;

    /**
     * 查询权限详情
     * @param param
     * @return
     * @throws BizException
     */
    public AuthorityDTO authDetail(RemoteAuthDetailParam param) throws BizException;

}
