package cn.com.duiba.cloud.manage.service.api.model.param.app;

import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description
 * @date 2021/12/27 10:09
 */
@Getter
@Setter
public class RemoteSubscribeAppParam extends BaseParam {

    private static final long serialVersionUID = -5450471347656123906L;

    /**
     * 租户应用名称
     */
    @Length(max = 15, message = "应用名称限定15字以内")
    private String tenantAppName = "默认应用";

    /**
     * appId
     */
    @NotNull(message = "appId 不能为空")
    private Long appId;
}
