package cn.com.duiba.cloud.manage.service.api.remoteservice.rights;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.rights.AllRightsDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.rights.AppRightsDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.rights.AppRightsQueryDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppRightsDeleteParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppRightsDetailParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppRightsQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppRightsRenameParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppRightsSaveParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppRightsSortUpdateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppRightsUpdateParam;

/**
 * 应用权益服务
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/11/22
 */
@AdvancedFeignClient
public interface RemoteAppRightsService {

    /**
     * 查询应用权益
     * @param queryParam
     * @return
     */
    public AppRightsQueryDTO appRightsQuery(RemoteAppRightsQueryParam queryParam) throws BizException;

    /**
     * 保存权益
     * @param saveParam
     * @throws BizException
     */
    public void appRightsSave(RemoteAppRightsSaveParam saveParam) throws BizException;

    /**
     * 更新权益
     * @param updateParam
     * @throws BizException
     */
    public void appRightsUpdate(RemoteAppRightsUpdateParam updateParam) throws BizException;

    /**
     * 删除应用权益
     * @param deleteParam
     * @throws BizException
     */
    public void appRightsDelete(RemoteAppRightsDeleteParam deleteParam) throws BizException;

    /**
     * 权益重命名
     * @param renameParam
     * @throws BizException
     */
    public void appRightsRename(RemoteAppRightsRenameParam renameParam) throws BizException;

    /**
     * 应用权益详情
     * @param detailParam
     * @return
     * @throws BizException
     */
    public AppRightsDetailDTO appRightsDetail(RemoteAppRightsDetailParam detailParam) throws BizException;

    /**
     * 修改权益排序
     * @param updateParam
     * @throws BizException
     */
    public void appRightsSortUpdate(RemoteAppRightsSortUpdateParam updateParam) throws BizException;

    /**
     * 查询所有权益
     * @return
     * @throws BizException
     */
    public AllRightsDTO allRights() throws BizException;
}
