package cn.com.duiba.cloud.manage.service.api.remoteservice.staff;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.staff.QueryStaffDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.staff.StaffDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.staff.StaffDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.staff.TenantStaffDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import cn.com.duiba.cloud.manage.service.api.model.param.RemoteIdParam;
import cn.com.duiba.cloud.manage.service.api.model.param.RemoteIdsParam;
import cn.com.duiba.cloud.manage.service.api.model.param.staff.RemoteChangeDeptStaffIdentifyParam;
import cn.com.duiba.cloud.manage.service.api.model.param.staff.RemoteChangeStaffIdentityParam;
import cn.com.duiba.cloud.manage.service.api.model.param.staff.RemoteGetAllStaffByTenantIdParam;
import cn.com.duiba.cloud.manage.service.api.model.param.staff.RemoteGetStaffByDeptIdRequest;
import cn.com.duiba.cloud.manage.service.api.model.param.staff.RemoteGetStaffRequest;
import cn.com.duiba.cloud.manage.service.api.model.param.staff.RemoteQueryStaffDetailParam;
import cn.com.duiba.cloud.manage.service.api.model.param.staff.RemoteSaveStaffRequest;
import cn.com.duiba.cloud.manage.service.api.model.param.staff.RemoteTenantStaffParam;
import cn.com.duiba.cloud.manage.service.api.model.param.staff.RemoteUpdateStaffDeptParam;
import cn.com.duiba.cloud.manage.service.api.utils.UploadResult;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 角色员工远程服务
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/11/8
 */
@AdvancedFeignClient
public interface RemoteStaffService {

    /**
     * 删除员工
     *
     * @param staffId
     * @return
     * @throws BizException
     */
    Long delStaff(RemoteIdParam staffId) throws BizException;

    Boolean delStaffs(RemoteIdsParam staffIds) throws BizException;

    /**
     * 变更部门 同时变成普通员工
     *
     * @param param
     * @return
     * @throws BizException
     */
    Boolean updateStaffDept(RemoteUpdateStaffDeptParam param);

    /**
     * 变更部门下员工身份
     *
     * @param param
     * @return
     * @throws BizException
     */
    Boolean changeStaffIdentity(RemoteChangeStaffIdentityParam param) throws BizException;

    /**
     * 获取指定部门下的员工数据 分页
     *
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<StaffDTO> getStaffByDeptId(RemoteGetStaffByDeptIdRequest param);

    UploadResult export(RemoteGetStaffByDeptIdRequest param) throws Exception;

    /**
     * 获取员工详情
     *
     * @param staffId 员工id
     * @return
     * @throws BizException
     */
    StaffDetailDTO getStaff(RemoteGetStaffRequest staffId) throws BizException;

    /**
     * @param param
     * @return
     * @throws BizException
     */
    StaffDTO getNotDeptAdminStaff(BaseParam param) throws BizException;

    /**
     * @param param
     * @return
     * @throws BizException
     */
    Long updateStaff(RemoteSaveStaffRequest param) throws BizException;

    void changeDeptStaffIdentify(RemoteChangeDeptStaffIdentifyParam param)throws BizException;

    /**
     * @param tenantId
     * @return
     */
    PageResponse<StaffDTO> getAllStaffByTenantId(RemoteGetAllStaffByTenantIdParam tenantId);

    List<TenantStaffDTO> selectByParam(RemoteTenantStaffParam tenantStaffParam);

    /**
     * 查询员工详情 - 包括手机号
     * @param param
     * @throws BizException
     */
    QueryStaffDetailDTO queryStaffDetail(RemoteQueryStaffDetailParam param) throws BizException;
}
