package cn.com.duiba.mapping.mode.message.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.message.service.api.dto.*;
import java.util.List;

/**
 * Created by guoyanfei .
 * 2020/5/20 .
 */
@AdvancedFeignClient
public interface RemoteSmsBackedService {

    /**
     * 查询所有的短信渠道
     * @return
     */
    List<SmsChannelDto> findAllChannels();

    /**
     * 查询所有有效的短信渠道
     * @return
     */
    List<SmsChannelDto> findAllValidChannels();

    /**
     * 更新短信渠道状态
     * @param channelId
     * @param status
     */
    void updateChannelStauts(Long channelId, Integer status);

    /**
     * 保存短信渠道
     * @param dto
     */
    void saveChannel(SmsChannelDto dto) throws BizException;

    /**
     * 签名分页查询
     * @param pagerRequest
     * @return
     */
    PagerResponse<SmsSignPageDto> pageSigns(PagerRequest pagerRequest);

    /**
     * 删除签名
     * @param signId
     */
    void deleteSign(Long signId);

    /**
     * 保存签名
     * @param dto
     */
    void saveSign(SmsSignSaveDto dto) throws BizException;

    /**
     * 查询单个签名，包含已经删除的
     * @param signId
     * @return
     */
    SmsSignDto getSign(Long signId);

    /**
     * 模板的分页查询
     * @param pagerRequest
     * @return
     */
    PagerResponse<SmsTemplatePageDto> pageTemplates(PagerRequest pagerRequest);

    /**
     * 删除模板
     * @param templateId
     */
    void deleteTemplate(Long templateId);

    /**
     * 保存模板
     * @param dto
     */
    void saveTemplate(SmsTemplateSaveDto dto) throws BizException;

    /**
     * 查询单个模版，包含已经删除的
     * @param templateId
     * @return
     */
    SmsTemplateDto getTemplate(Long templateId);

    /**
     * 查询单个可用模板（不包含删除的）
     * @return
     */
    SmsTemplateDto getValidTemplate(Long templateId);

    /**
     * 查询单个可用签名（不包含删除的）
     * @param signId
     * @return
     */
    SmsSignDto getValidSign(Long signId);
}
