package cn.com.duiba.message.service.api.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 短信发送凭据(响应)
 * Created by guoyanfei .
 * 2018/11/22 .
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SmsSendInvoice implements Serializable {

    private static final long serialVersionUID = -6489771406520881974L;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 第三方短信平台响应成功
     */
    private Boolean success;

    /**
     * 发送的短信的唯一id。非数字，例: 1_2739847598347，由兑吧短信服务生成
     * 发送失败的情况下，此字段为null
     */
    private String dbSmsId;

    /**
     * 发送失败的情况下的错误信息
     */
    private String errorMsg;

    public static SmsSendInvoice successResult(String mobile, String dbSmsId) {
        return new SmsSendInvoice(mobile, true, dbSmsId, null);
    }

    public static SmsSendInvoice failResult(String mobile, String errorMsg) {
        return new SmsSendInvoice(mobile, false, null, errorMsg);
    }
}
