package cn.com.duiba.message.service.api.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 短信发送结果，一般为
 * Created by guoyanfei .
 * 2018/11/22 .
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SmsSendResult implements Serializable {

    private static final long serialVersionUID = 123613563956582057L;

    /**
     * 发送的短信的唯一id。非数字，例: 1_2739847598347，由兑吧短信服务生成
     * 在短信发送的响应结果中获取
     */
    private String dbSmsId;

    /**
     * 短信发送的回调结果。
     * 参考，ReportStatusEnum
     */
    private Integer resultCode;

}
