package cn.com.duiba.message.service.api.dto;

import cn.com.duiba.message.service.api.enums.LetterNotifyModeEnum;
import cn.com.duiba.message.service.api.enums.LetterSourceEnum;
import cn.com.duiba.message.service.api.enums.LetterTypeEnum;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-06-17 14:19
 * @descript: 使用整体跳转ActionCard样式
 * @version: 1.0
 */
@Data
@NoArgsConstructor
public abstract class LetterSendRquest {

    /**
     * 类型
     */
    private LetterTypeEnum letterTypeEnum;

    /**
     * 主题
     */
    private String subject;

    /**
     * 内容
     */
    private String content;

    /**
     * 通知类型
     */
    private LetterNotifyModeEnum letterNotifyModeEnum;

    /**
     * 　cron表达式
     * 当通知类型为LetterNotifyModeEnum.regular，必填
     */
    private String cronExpression;

    /**
     * 接手方来源
     */
    private LetterSourceEnum letterSourceEnum;

    /**
     * 接收方ID
     */
    private String receiveId;
}
