package cn.com.duiba.message.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.message.service.api.dto.DingRobotDto;
import cn.com.duiba.message.service.api.dto.MessageRobotBindDto;

import java.util.List;
import java.util.Set;

@AdvancedFeignClient
public interface RemoteRobotService {

    /**
     * 获取所有机器人列表
     * 不传name获取的是全部
     *
     * @return
     */
    List<DingRobotDto> getAll(String robotName);

    /**
     * 添加机器人
     *
     * @param dingRobotDto
     */
    void add(DingRobotDto dingRobotDto);

    /**
     * 更新机器人
     *
     * @param dingRobotDto
     */
    void update(DingRobotDto dingRobotDto);

    /**
     * 获取指定机器人
     *
     * @param id
     * @return
     */
    DingRobotDto get(Long id);

    /**
     * 获取业务线对应的机器人
     *
     * @param orgId
     * @return
     */
    DingRobotDto findOrganizationRobot(Long orgId);

    /**
     * 配置业务线的机器人
     *
     * @param orgId   业务线Id
     * @param robotId 机器人的Id
     */
    void configOrganizationRobot(Long orgId, Long robotId) throws BizException;

    /**
     * 获取系统所在业务线的机器人
     *
     * @param appName
     * @return
     */
    DingRobotDto getByAppName(String appName);

    /**
     * 获取业务线绑定的机器人
     * @param businessIds
     * @return
     */
    List<MessageRobotBindDto> getByBusinessIds(List<Long> businessIds);
}
