package cn.com.duiba.message.service.api.dto;

import lombok.Data;
import org.springframework.core.io.InputStreamResource;

import java.io.File;
import java.io.Serializable;

/**
 * 用 system@duiba.com.cn 邮箱发邮件
 */
@Data
public class DuibaSystemMailMsgRequest implements Serializable {

    private static final long serialVersionUID = 3230574455449028475L;

    /**
     * 发送目标邮箱，可以是多个
     */
    private String[] toMail;

    /**
     * 邮件标题
     */
    private String subject;

    /**
     * 邮件内容
     */
    private String text;

    /**
     * 是否支持html
     */
    private boolean isHtml;

    /** 附件url*/
    private String appendixUrl;
}
