package cn.com.duiba.message.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.message.service.api.dto.*;
import com.github.pagehelper.PageSerializable;

import java.util.List;
import java.util.Set;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-10-16 15:12
 * @descript:
 * @version: 1.0
 */
@AdvancedFeignClient
public interface RemoteLetterService {

    /**
     * 发送站内信
     *
     * @param request
     * @return
     */
    LetterSendResult send(LetterSendRquest request);

    /**
     * 已读
     *
     * @param letterIds
     * @return
     */
    void read(List<Long> letterIds, String receiveId);

    /**
     * 删除
     *
     * @param letterId
     * @return
     */
    void delete(Long letterId, String receiveId);

    /**
     * 查询
     *
     * @param requestDto
     * @return
     */
    PageSerializable<LetterDto> search(LetterRequestDto requestDto);

    /**
     * 有新的消息的用户列表
     *
     * @return
     */
    List<String> hasNewLetter(Set<String> receiveId);

    /**
     * 增加消息屏蔽
     *
     * @param screenRequestDto
     */
    void addScreen(LetterScreenRequestDto screenRequestDto);
}
