package cn.com.duiba.message.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.message.service.api.dto.SmsSendInvoiceV2;
import cn.com.duiba.message.service.api.dto.SmsVerificationCodeParam;

import java.util.List;

/**
 * 新版本短信服务
 * Created by guoyanfei .
 * 2020/5/14 .
 */
@AdvancedFeignClient
public interface RemoteSmsV2Service {

    /**
     * 发送单条验证码短信
     * @param bizKey 业务线key，联系中台获取，该参数每条业务线一个，不会变动【建议放在配置项中】
     * @param param 验证码短信所需参数 {@link SmsVerificationCodeParam}
     * @return 短信发送凭证 {@link SmsSendInvoiceV2}
     */
    SmsSendInvoiceV2 sendVerificationCode(String bizKey, SmsVerificationCodeParam param) throws BizException;

    /**
     * 批量发送验证码短信
     * @param bizKey 业务线key，联系中台获取，该参数每条业务线一个，不会变动【建议放在配置项中】
     * @param paramList 多条验证码短信所需参数list {@link SmsVerificationCodeParam}
     * @return 短信发送凭证 {@link SmsSendInvoiceV2}
     */
    List<SmsSendInvoiceV2> batchSendVerificationCode(String bizKey, List<SmsVerificationCodeParam> paramList) throws BizException;
}
