package cn.com.duiba.message.service.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-10-16 16:53
 * @descript:
 * @version: 1.0
 */
@Data
public class LetterRequestDto implements Serializable {

    private static final long serialVersionUID = -4801216699298970440L;

    /**
     * 类型 - LetterTypeEnum
     */
    private Integer letterType;

    /**
     * 主题
     */
    private String subject;

    /**
     * 接收方ID
     */
    private String receiveId;

    /**
     * 状态：0-未读 1-已读
     */
    private Integer receiveStatus;

    /**
     * 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date benginTime;

    /**
     * 结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    private Integer pageSize = 10;

    private Integer curPage = 1;

    private String orderBy = "gmt_create";

    private String sort = "desc";
}
