package cn.com.duiba.message.service.api.enums;

/**
 * 短信服务类型
 */
public enum SmsServiceTypeEnum {

    VERIFICATION_CODE(1, "验证码类短信"),
    NOTICE(2, "通知类短信");

    private final int value;

    private final String desc;

    SmsServiceTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String desc() {
        return desc;
    }

    public int value() {
        return value;
    }

    public static SmsServiceTypeEnum get(int value) {
        for (SmsServiceTypeEnum item : SmsServiceTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        throw new RuntimeException("invalid enum value!");
    }
}
