package cn.com.duiba.message.service.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * 具体官方文档： https://help.aliyun.com/document_detail/393529.html?spm=a2c4g.11186623.0.0.7c5b2ad51k5mx8
 */
@Data
public class AliCallReport implements Serializable {

    private static final long serialVersionUID = 9215408340806830000L;

    /* 本次呼叫的请求id */
    private String requestId;

    private String phoneNumber;

    /* 电话模板ID - 可联系运维在阿里云自己维护 */
    private String ttsCode;

    /* 应用名称 */
    private String appName;

    /* 回调ID */
    private String callId;

    // 以下是阿里云返回的结果, 请查看官方文档
    // code == "OK"  &&  duration == "0" 代表用户接听成功
    // 注意是大写的OK
    private String code;
    private String message;
    private String caller;
    private String startDate;
    private String stateDesc;
    private String duration;
    private String callerShowNumber;
    private String createTime;
    private String state;
    private String endDate;
    private String calleeShowNumber;
    private String callee;
    private String aRingTime;
    private String aEndTime;
    private String bRingTime;
    private String bEndTime;
}
