package cn.com.duiba.message.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019年01月29日 17:18
 * @descript:
 * @version: 1.0
 */
@Data
public class CallReport implements Serializable {

    private static final long serialVersionUID = 9215408340806830000L;

    /**
     * 呼叫id
     */
    private Long id;

    //通话时长，单位秒
    private Integer callDuration;

    /**
     * 呼叫结果状态码{@link cn.com.duiba.message.service.api.enums.CallResultCodeEnum}
     */
    private String callStatusCode;

    /**
     * 早媒体结果状态码{@link cn.com.duiba.message.service.api.enums.CallEarlyCodeEnum}
     */
    private String earlyMediaCode;

    /**
     * 通话开始时间,未接通则为空
     */
    private Date callStart;

    /**
     * 通话结束时间，未接通则为空
     */
    private Date callEnd;
}
