package cn.com.duiba.message.service.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @Author yuquanfeng
 * @Date 2024/2/21
 * @Description
 **/
@Data
public class DingProjectTaskRequest implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 项目id 是否必填-是
     */
    private String projectId;
    /**
     * 操作者userId 对应ssoId 是否必填-是
     */
    private Long userId;
    /**
     * 任务标题 是否必填-是
     */
    private String content;
    /**
     * 执行人 ssoId 是否必填-否
     */
    private Long executorId;
    /**
     * 任务截止时间，格式：YYYY-MM-DDTHH:mm:ssZ（ISO 8601/RFC 3339）  是否必填-否
     */
    private String dueDate;
    /**
     * 任务备注 是否必填-否
     */
    private String note;
    /**
     * 优先级 是否必填-否
     */
    private Integer priority;
    /**
     * 开始时间  格式：YYYY-MM-DDTHH:mm:ssZ（ISO 8601/RFC 3339） 是否必填-否
     */
    private String startDate;
    /**
     * 任务的可见性规则。
     *
     * involves：仅任务参与者可见
     *
     * members：项目成员可见
     */
    private String visible;
}
