package cn.com.duiba.message.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2024/2/5
 * @Description
 **/
@Data
public class DingToDoMsgRequest implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 待办标题，最大长度1024字节。必填-是
     */
    private String subject;
    /**
     * 待办备注，最大长度4096字节。必填-否
     */
    private String description;
    /**
     * 截止时间，Unix时间戳，单位毫秒。 必填-否
     */
    private Long dueTime;
    /**
     * 执行者列表，需传用户的adminId，最大数量100：
     *
     */
    private List<Long> executorAdminIds;
    /**
     * 参与者列表，需传用户的adminId，最大长度100：
     *
     */
    private List<Long> participantAdminIds;


}
