package cn.com.duiba.message.service.api.dto;

import cn.com.duiba.message.service.api.enums.LetterNotifyModeEnum;
import cn.com.duiba.message.service.api.enums.LetterSourceEnum;
import cn.com.duiba.message.service.api.enums.LetterTypeEnum;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-06-17 14:19
 * @descript: 使用整体跳转ActionCard样式
 * @version: 1.0
 */
@Data
@NoArgsConstructor
public class LetterSendRquest implements Serializable {

    private static final long serialVersionUID = 4661436103153630813L;

    /**
     * 类型
     */
    private LetterTypeEnum letterTypeEnum;

    /**
     * 自定义类型，可能为null，如果 letterTypeEnum存在，优先使用letterTypeEnum
     */
    private Integer customLetterType;

    /**
     * 主题
     */
    private String subject;

    /**
     * 内容
     */
    private String content;

    /**
     * 通知类型
     */
    private LetterNotifyModeEnum letterNotifyModeEnum;

    /**
     * 通知事件
     * 当通知类型为LetterNotifyModeEnum.schedule需指定发送时间
     */
    private Date sendDate;

    /**
     * 接手方来源
     */
    private LetterSourceEnum letterSourceEnum;

    /**
     * 接收方ID
     */
    private String receiveId;

    public Integer getLetterType() {
        if (letterTypeEnum != null) {
            return letterTypeEnum.getCode();
        }
        if (customLetterType != null) {
            return customLetterType;
        }
        return null;
    }
}
