package cn.com.duiba.message.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.message.service.api.dto.*;
import cn.com.duiba.message.service.api.enums.DingMsgTypeEnum;

import java.util.List;

@AdvancedFeignClient
public interface RemoteDingMsgService {

    /**
     * 根据机器人ID发送自定义机器人消息RemoteDingMsgService
     *
     * @param robotId     机器人ID
     * @param msgTypeEnum 消息类型
     * @param request     消息体
     * @return
     */
    DingMsgSendResult sendRobotByRobotId(Long robotId, DingMsgTypeEnum msgTypeEnum, DingGeneralMsgRquest request);

    /**
     * 根据机器人token发送自定义机器人消息
     *
     * @param token       机器人ID
     * @param msgTypeEnum 消息类型
     * @param request     消息体
     * @return
     */
    DingMsgSendResult sendRobotByToken(String token, DingMsgTypeEnum msgTypeEnum, DingGeneralMsgRquest request);

    /**
     * 根据机器人token发送自定义告警机器人消息
     * ps:非通知型机器人
     * @param msgTypeEnum 消息类型
     * @param appName sso的系统名称
     * @param request     消息体
     * @return
     */
    DingMsgSendResult sendRobotByAppName(String appName, DingMsgTypeEnum msgTypeEnum, DingGeneralMsgRquest request);

    /**
     * 根据机器人token发送自定义通知型机器人消息
     * ps:非告警型机器人
     * @param msgTypeEnum 消息类型
     * @param appName sso的系统名称
     * @param request     消息体
     * @return
     */
    DingMsgSendResult sendNotifyRobotByAppName(String appName, DingMsgTypeEnum msgTypeEnum, DingGeneralMsgRquest request);

    /**
     * 根据机器人token发送自定义机器人消息(异步发送)
     *
     * @param token       机器人ID
     * @param msgTypeEnum 消息类型
     * @param request     消息体
     */
    void sendRobotByTokenAsync(String token, DingMsgTypeEnum msgTypeEnum, DingGeneralMsgRquest request);

    /**
     * 发送工作通知-全体员工
     *
     * @param request 消息体
     * @return
     */
    DingMsgSendResult sendCorpConversationToAll(DingMsgTypeEnum msgTypeEnum, DingGeneralMsgRquest request);

    /**
     * 发送工作通知
     *
     * @param adminIds 接收消息方
     * @param request  消息体
     * @return
     */
    DingMsgSendResult sendCorpConversation(List<Long> adminIds, DingMsgTypeEnum msgTypeEnum, DingGeneralMsgRquest request);

    /**
     * 发送整体跳转卡片类型的工作通知
     *
     * @param adminIds  接收消息方
     * @param msgRquest Actioncard样式
     * @return
     */
    DingMsgSendResult sendCardCorpConversation(List<Long> adminIds, DingSingleCardMsgRquest msgRquest);

    /**
     * 发送整体跳转卡片类型的工作通知- 全体
     *
     * @param msgRquest Actioncard样式
     * @return
     */
    DingMsgSendResult sendCardCorpConversationToAll(DingSingleCardMsgRquest msgRquest);

    /**
     * 发送独立跳转卡片类型的工作通知
     *
     * @param adminIds  接收消息方
     * @param msgRquest Actioncard样式
     * @return
     */
    DingMsgSendResult sendIndepenCardCorpConversation(List<Long> adminIds, DingIndependenceCardMsgRquest msgRquest);

    /**
     * 发送卡片类型的工作通知- 全体
     *
     * @param msgRquest Actioncard样式
     * @return
     */
    DingMsgSendResult sendIndepenCardCorpConversationToAll(DingIndependenceCardMsgRquest msgRquest);

    /**
     * 发送个人待办消息
     *
     * @param dingToDoMsgRequest
     * @return
     */
    DingTalkMsgSendResult sendPersonalToDo(DingToDoMsgRequest dingToDoMsgRequest);

    /**
     * 发送钉钉项目任务
     * @param dingProjectTaskRequest
     * @return
     */
    DingTalkMsgSendResult sendProjectTask(DingProjectTaskRequest dingProjectTaskRequest);


}
