package cn.com.duiba.message.service.api.dto;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-06-17 14:19
 * @descript: 使用独立跳转ActionCard样式
 * @version: 1.0
 */
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
public class DingIndependenceCardMsgRquest extends DingCardMsgRquest implements Serializable {

    private static final long serialVersionUID = -5148827622511098359L;

    /**
     * 使用独立跳转ActionCard样式时的按钮排列方式;
     * 竖直排列: 0，横向排列: 1;
     * 必须与btnJsonList同时设置.
     */
    private int btnOrientation = 0;

    /**
     * 使用独立跳转ActionCard样式时的按钮列表；
     * 必须与btn_orientation同时设置
     */
    private List<BtnJsonModel> btnJsonList;

    public static class BtnJsonModel implements Serializable {

        private static final long serialVersionUID = 6050535712906097073L;

        /**
         * 使用独立跳转ActionCard样式时的按钮的标题
         */
        private String title;

        /**
         * 消息点击链接地址，当发送消息为小程序时支持小程序跳转链接
         */
        private String actionUrl;

        public BtnJsonModel(String title, String actionUrl) {
            this.title = title;
            this.actionUrl = actionUrl;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getActionUrl() {
            return actionUrl;
        }

        public void setActionUrl(String actionUrl) {
            this.actionUrl = actionUrl;
        }
    }
}
