package cn.com.duiba.message.service.api.enums;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019年01月29日 17:00
 * @descript: 呼叫结果状态
 * @version: 1.0
 */
public enum CallResultCodeEnum {

    BEGIN_CALL("200101", "开始呼叫"),
    SUCC_CALL("200000", "用户听完语音"),
    NO_ANSWER("200003","用户收到呼叫但未接听"),
    HANG_UP("200001","用户提前挂机未完整收听"),
    REFUSE("200005","用户无法接通（拒绝）"),
    UNABLE_CONNECT("200007","用户无法接通（不在服务区）"),
    CALLED_BELL("200201", "被叫响铃"),
    CALLED_ANSWER("200102", "被叫接听"),
    CALLED_END("200100", "呼叫结束");

    CallResultCodeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private String value;

    private String desc;

    public String value() {
        return value;
    }

    public String desc() {
        return desc;
    }


}
