package cn.com.duiba.message.service.api.enums;

/**
 * 回调结果枚举
 * Created by guoyanfei .
 * 2018/11/22 .
 */
public enum ReportStatusEnum {

    NO_CALLBACK(-1, "还未收到回调"),
    INVALID_DBSMSID(-2, "无效的dbSmsId"),
    DELIVRD(0, "短信发送成功"),
    UNKNOWN(1, "未知短信状态"),
    REJECTD(2, "短信被短信中心拒绝"),
    MBBLACK(3, "目的号码是黑名单号码"),
    REJECT(4, "审核驳回"),
    CLOSE_DOWN(11, "关机或停机"),
    EMPTY_NUM(12, "空号");

    ReportStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private int value;

    private String desc;

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static ReportStatusEnum get(int value) {
        for (ReportStatusEnum item : ReportStatusEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        throw new RuntimeException("invalid enum value!");
    }

}
