package cn.com.duiba.message.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class SmsChannelDto implements Serializable {

    private static final long serialVersionUID = -3719447341257412229L;

    private Long id;

    /**
     * 渠道名称
     */
    private String channelName;

    /**
     * 服务类型 位运算字段 0位表示验证码类 1位表示通知类
     * {@link cn.com.duiba.message.service.api.enums.SmsServiceTypeBitEnum}
     */
    private Long serviceType;

    /**
     * 渠道状态 0禁用 1启用
     * {@link cn.com.duiba.message.service.api.enums.SmsChannelStatusEnum}
     */
    private Integer channelStatus;

    /**
     * 渠道的一些规则json
     * json value使用到枚举，{@link cn.com.duiba.message.service.api.enums.SmsChannelApiParamRuleEnum}
     */
    private String apiParamRule;

    private Integer channelPayload;

    private String channelKey;

    private Date gmtCreate;

    private Date gmtModified;

    public void grantServiceType(int type) {
        int v = 1 << type;
        serviceType = serviceType | v;
    }

    public void ungrantServiceType(int type) {
        int v = 1 << type;
        v = ~v;
        serviceType = serviceType & v;
    }

    public boolean isServiceType(int type) {
        int v = 1 << type;
        long ret = serviceType & v;
        return ret != 0;
    }

}
