package cn.com.duiba.message.service.api.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * 验证码短信的请求参数体
 * Created by guoyanfei .
 * 2020/5/14 .
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SmsVerificationCodeParam implements Serializable {

    private static final long serialVersionUID = 283464390056776727L;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 兑吧短信平台的签名id
     */
    private Long signId;

    /**
     * 兑吧短信平台的模板id
     */
    private Long templateId;

    /**
     * 模板中的插值的 键值对
     */
    private Map<String, String> templateParam;

    @Override
    public String toString() {
        return "SmsVerificationCodeParam{" + "mobile='" + mobile + '\'' + ", signId=" + signId + ", templateId=" + templateId + ", templateParam=" + templateParam + '}';
    }
}
