package cn.com.duiba.message.service.api.enums;

/**
 * 短信通道接口规则
 */
public enum SmsChannelApiParamRuleEnum {

    ID(0, "id"),
    CONTENT(1, "内容");

    private final int value;

    private final String desc;

    SmsChannelApiParamRuleEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String desc() {
        return desc;
    }

    public int value() {
        return value;
    }

    public static SmsChannelApiParamRuleEnum get(int value) {
        for (SmsChannelApiParamRuleEnum item : SmsChannelApiParamRuleEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        throw new RuntimeException("invalid enum value!");
    }
}
