package cn.com.duiba.message.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.message.service.api.dto.AliCallReport;
import cn.com.duiba.message.service.api.dto.AliCallResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAliCallService {

    /**
     * 打电话
     *
     * @param mobile  手机号
     * @param ttsCode 电话模版，(可为空，为空使用默认模板)（需要根据既定的模板生成的内容，业务方需要在阿里云语音服务控制台添加好对应的模板）
     * @return
     */
    AliCallResult call(String mobile, String ttsCode);

    /**
     * 查询呼叫记录
     * <p>
     * 优先从兑吧持久化记录查询，如果没有查到去阿里云查询
     *
     * @param callId 呼叫ID
     * @return
     */
    AliCallReport queryByCallId(String callId);

    /**
     * 查询呼叫记录
     * <p>
     * 优先从兑吧持久化记录查询，如果没有查到去阿里云查询
     *
     * @param callId 呼叫ID
     * @return
     */
    List<AliCallReport> queryByCallIdList(List<String> callId);


    /**
     * 通过系统名称给系统owner拨打电话：
     * - 随机给owner拨号，有一个接通之后不再拨号，如都没有接听，继续给业务线服务人拨号（随机），有一个拨号成功立马返回
     *
     * @param appName 系统名称
     * @param ttsCode 电话模版（需要根据既定的模板生成的内容，业务方需要在阿里云语音服务控制台添加好对应的模板）
     * @return requestId 请求ID，可以用于查询请求结果
     */
    String callByAppName(String appName, String ttsCode);

    /**
     * 通过电话列表拨打电话：
     * -  按照顺序给电话列表拨号，有一个接通之后不再拨号，有一个拨号成功立马结束
     *
     * @param mobileList 手机号码列表
     * @param ttsCode    电话模版（需要根据既定的模板生成的内容，业务方需要在阿里云语音服务控制台添加好对应的模板）
     * @return requestId 请求ID，可以用于查询请求结果
     */
    String callByMobileList(List<String> mobileList, String ttsCode);

    /**
     * 查询呼叫记录(主要为了批量异步查询)
     *
     * @param requestId 呼叫ID
     * @return
     */
    List<AliCallReport> queryByRequestId(String requestId);
}
