package cn.com.duiba.message.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.message.service.api.dto.BizLineDto;

import java.util.List;

/**
 * Created by guoyanfei .
 * 2020/5/20 .
 */
@AdvancedFeignClient
public interface RemoteBizLineBackendService {

    /**
     * 查询全部业务线
     * @return
     */
    List<BizLineDto> findAll();

    /**
     * 变更业务线状态
     * @param id
     * @param status {@link cn.com.duiba.message.service.api.enums.BizLineStatusEnum}
     */
    void updateStatus(Long id, Integer status);

    /**
     * 删除业务线
     * @param id
     */
    void delete(Long id);

    /**
     * 保存操作
     * @param bizLineName
     */
    void create(String bizLineName) throws BizException;
}
