package cn.com.duiba.message.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.message.service.api.dto.DuibaSystemMailMsgRequest;
import cn.com.duiba.message.service.api.dto.SimpleMailMsgRequest;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-07-03 13:47
 * @descript:
 * @version: 1.0
 */
@AdvancedFeignClient
public interface RemoteMailService {

    /**
     * 发送普通的邮件
     * @param msgRequest
     */
    void sendSimpleMail(SimpleMailMsgRequest msgRequest);

    /**
     * 用兑吧 system@duiba.com.cn 发邮件
     * @param msgRequest
     */
    void sendDuibaSystemMail(DuibaSystemMailMsgRequest msgRequest);

    /**
     * 发送带附件的邮件
     * 目前附件只支持 xlxs类型的excel
     */
    void sendSystemMailCarrayAppendix(DuibaSystemMailMsgRequest msgRequest);
}
