package cn.com.duiba.message.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.message.service.api.dto.SmsSendInvoice;
import cn.com.duiba.message.service.api.dto.SmsSendResult;

import java.util.List;

/**
 * 短信服务接口
 * Created by guoyanfei .
 * 2018/11/22 .
 */
@AdvancedFeignClient
public interface RemoteSmsService {

    /**
     * 发送单条短信
     * @param mobile 手机号
     * @param content 短信内容（需要根据既定的模板生成的内容，业务方需要在约定的短信服务商后台添加好对应的模板）
     * @param bizCode 业务方编号 参考，BizCodeEnum
     * @return
     * @throws BizException
     */
    SmsSendInvoice send(String mobile, String content, int bizCode) throws BizException;

    /**
     * 给一批手机号发送相同内容的短信
     * @param mobiles 一批手机号
     * @param content 短信内容（需要根据既定的模板生成的内容，业务方需要在约定的短信服务商后台添加好对应的模板）
     * @param bizCode 业务方编号 参考，BizCodeEnum
     * @return
     * @throws BizException
     */
    List<SmsSendInvoice> batchMobilesSend(List<String> mobiles, String content, int bizCode) throws BizException;

    /**
     * 查询短信发送的回调结果
     * @param dbSmsId 注意：dbSmsId 创建后只保留7天，所以如果调用send接口后超过7天再来查询结果，会出现找不到结果的情况
     * @return
     */
    SmsSendResult querySendResult(String dbSmsId) throws BizException;

    /**
     * 批量查询短信发送的回调结果
     * @param dbSmsIds 注意：dbSmsId 创建后只保留7天，所以如果调用send接口后超过7天再来查询结果，会出现找不到结果的情况
     * @return
     * @throws BizException
     */
    List<SmsSendResult> batchQuerySendResult(List<String> dbSmsIds) throws BizException;
}
