package cn.com.duiba.message.service.rest.controller;

import lombok.Data;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2018年12月10日 13:58
 * @descript:
 * @version: 1.0
 */
@Data
public class Result<T> {

    protected boolean success = Boolean.TRUE;

    protected T data;

    protected Integer totalCount = 0;

    protected String message;

    protected Result() {

    }

    protected Result(boolean success, String message) {
        this.success = success;
        this.message = message;
    }

    protected Result(T data) {
        this.data = data;
    }

    protected Result(T data, Integer totalCount) {
        this.data = data;
        this.totalCount = totalCount;
    }

    public static <T> Result setSucc(T data, Integer totalCount) {
        return new Result(data, totalCount);
    }

    public static <T> Result setSucc(T data) {
        return new Result(data);
    }

    public static Result setSucc() {
        return new Result();
    }

    public static Result setFail(String message) {
        return new Result(Boolean.FALSE, message);
    }

}
