/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.message.service.rest.controller;

import cn.com.duiba.message.service.api.dto.LetterRequestDto;
import cn.com.duiba.message.service.api.remoteservice.RemoteLetterService;
import cn.com.duiba.message.service.rest.controller.Result;
import cn.com.duiba.message.service.rest.controller.SsePushNotifySchedule;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.CsrfOff;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"/message/service/letter"})
public class LetterController {
    @Resource
    private RemoteLetterService remoteLetterService;
    @Autowired
    private SsePushNotifySchedule ssePushNotifySchedule;

    @GetMapping(value={"/my"})
    public Result getMyLetters(LetterRequestDto requestDto) {
        Long adminId = RequestTool.getAdminId();
        requestDto.setReceiveId(String.valueOf(adminId));
        PageSerializable letters = this.remoteLetterService.search(requestDto);
        return Result.setSucc(letters.getList(), (int)letters.getTotal());
    }

    @CsrfOff
    @GetMapping(value={"/pushNew"})
    public SseEmitter pushNewLetter() {
        SseEmitter emitter = new SseEmitter(Long.valueOf(86400000L));
        Long adminId = RequestTool.getAdminId();
        if (adminId == null) {
            SseEmitter.SseEventBuilder builder = SseEmitter.event().data((Object)"\u6ca1\u6709\u767b\u5f55\u4fe1\u606f");
            try {
                emitter.send(builder);
                emitter.complete();
            }
            catch (IOException e) {
                emitter.completeWithError((Throwable)e);
            }
            return emitter;
        }
        String adminIdStr = String.valueOf(adminId);
        this.ssePushNotifySchedule.registerEmitter(adminIdStr, emitter);
        return emitter;
    }

    @GetMapping(value={"/hasNew"})
    public Result hasNew() {
        Long adminId = RequestTool.getAdminId();
        if (adminId == null) {
            return Result.setFail("\u672a\u76d1\u6d4b\u5230\u767b\u5f55\u4fe1\u606f");
        }
        String adminIdStr = String.valueOf(adminId);
        List hasReceives = this.remoteLetterService.hasNewLetter((Set)Sets.newHashSet((Object[])new String[]{adminIdStr}));
        return Result.setSucc(hasReceives.contains(adminIdStr));
    }

    @PostMapping(value={"/read"})
    public Result read(@RequestBody List<Long> letterIds) {
        Long adminId = RequestTool.getAdminId();
        this.remoteLetterService.read(letterIds, String.valueOf(adminId));
        return Result.setSucc();
    }

    @PostMapping(value={"/delete"})
    public Result read(Long letterId) {
        Long adminId = RequestTool.getAdminId();
        this.remoteLetterService.delete(letterId, String.valueOf(adminId));
        return Result.setSucc();
    }
}

