/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.message.service.rest.controller;

import cn.com.duiba.message.service.api.remoteservice.RemoteLetterService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class SsePushNotifySchedule {
    private static final Logger log = LoggerFactory.getLogger(SsePushNotifySchedule.class);
    @Resource
    private RemoteLetterService remoteLetterService;
    private final Map<String, SseEmitter> emitters = new ConcurrentHashMap<String, SseEmitter>();

    void registerEmitter(String receiveId, SseEmitter emitter) {
        emitter.onCompletion(() -> this.removeEmitter(receiveId));
        emitter.onTimeout(() -> this.removeEmitter(receiveId));
        SseEmitter.SseEventBuilder builder = SseEmitter.event().id(UUID.randomUUID().toString()).data((Object)"connected");
        try {
            emitter.send(builder);
        }
        catch (IOException e) {
            return;
        }
        this.emitters.put(receiveId, emitter);
    }

    private void removeEmitter(String receiveId) {
        this.emitters.remove(receiveId);
    }

    @Scheduled(fixedRate=10000L)
    public void doNotify() {
        ArrayList deadEmitters = Lists.newArrayList();
        List receiveIds = this.remoteLetterService.hasNewLetter(this.emitters.keySet());
        for (Map.Entry<String, SseEmitter> entry : this.emitters.entrySet()) {
            SseEmitter sseEmitter = entry.getValue();
            String receiveId = entry.getKey();
            if (!receiveIds.contains(receiveId)) continue;
            SseEmitter.SseEventBuilder builder = SseEmitter.event().id(UUID.randomUUID().toString()).data((Object)true);
            try {
                sseEmitter.send(builder);
                sseEmitter.complete();
            }
            catch (IOException e) {
                deadEmitters.add(receiveId);
            }
        }
        deadEmitters.forEach(this.emitters::remove);
    }
}

