package cn.com.duiba.millionaire.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.millionaire.center.api.dto.MillionaireQuesionBagDto;
import cn.com.duiba.millionaire.center.api.dto.MillionaireQuesionDto;

import java.util.List;
import java.util.Map;

/**
 * Created by sty on 2018/1/18.
 * 冲顶大会  题库后台配置接口
 */
@AdvancedFeignClient
public interface RemoteMillionaireQuesionBagService {
    /**
     *
     * findAllQuesionBag:(这里用一句话描述这个方法的作用). <br/>
     * 查询题库信息
     * offset  开始  max 条数  offset为null 时 查询全部
     * @param queryMap
     * @return
     * @since JDK 1.8
     */
    public List<MillionaireQuesionBagDto> findAllQuesionBag(Map<String, Object> queryMap);

    /**
     *
     * countMillionaireQuesionBagBackendList:(这里用一句话描述这个方法的作用). <br/>
     * 查询题库总数据
     * @param queryMap
     * @return
     * @since JDK 1.8
     */
    public Integer countMillionaireQuesionBagBackendList(Map<String, Object> queryMap);

    /**
     *
     * getMillionaireQuesionBagBackendList:(这里用一句话描述这个方法的作用). <br/>
     * 查询题库总数据
     * offset  开始  max 条数
     * @param queryMap
     * @return
     * @since JDK 1.8
     */
    public List<MillionaireQuesionBagDto> getMillionaireQuesionBagBackendList(Map<String, Object> queryMap);

    /**
     *
     * saveOrUPdateMillionaireQuesionBag:(这里用一句话描述这个方法的作用). <br/>
     * 更新或者保存题库
     *
     * @param dto
     * @return
     * @since JDK 1.8
     */
    public Boolean saveOrUPdateMillionaireQuesionBag(MillionaireQuesionBagDto dto);

    /**
     *
     * findAllMillionaireQuesionByBagId:(这里用一句话描述这个方法的作用). <br/>
     * 查询题库 下所有题目信息
     * @param id
     * @return
     * @since JDK 1.8
     */
    public List<MillionaireQuesionDto> findAllMillionaireQuesionByBagId(Long id);

    /**
     *
     * saveOrUPdateMillionaireQuesionBag:(这里用一句话描述这个方法的作用). <br/>
     * 更新或者保存 题目信息
     *
     * @param dto
     * @return
     * @since JDK 1.8
     */
    public Boolean saveOrUpdateMillionaireQuesion(MillionaireQuesionDto dto);

    /**
     *
     * delete:(这里用一句话描述这个方法的作用). <br/>
     * 1:题库 删除，2：题目删除
     *
     * @param id
     *
     * @return
     * @since JDK 1.8
     */
    public Boolean delete(Long id, Integer type);

    /**
     *
     * findQuesionById:(这里用一句话描述这个方法的作用). <br/>
     * 题目信息查询
     *
     * @param id
     *
     * @return
     * @since JDK 1.8
     */
    public MillionaireQuesionDto findQuesionById(Long id);
}
