/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.millionaire.center.api.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum AccountTypeEnum {
    WIN_INCOME(1, "\u4e2d\u5956\u83b7\u5f97"),
    WITHDRAW_ONLINE(2, "\u7ebf\u4e0a\u63d0\u73b0"),
    WITHDRAW_OFFLINE(3, "\u7ebf\u4e0b\u63d0\u73b0"),
    WITHDRAW_FAIL_PAYBACK(4, "\u63d0\u73b0\u5931\u8d25\u8fd4\u8fd8");

    private static Map<Integer, AccountTypeEnum> typeEnumMap;
    private Integer code;
    private String desc;

    public static AccountTypeEnum getByCode(int code) {
        AccountTypeEnum type = typeEnumMap.get(code);
        if (type == null) {
            return null;
        }
        return type;
    }

    private AccountTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        typeEnumMap = Maps.newHashMap();
        for (AccountTypeEnum typeEnum : AccountTypeEnum.values()) {
            typeEnumMap.put(typeEnum.getCode(), typeEnum);
        }
    }
}

