package cn.com.duiba.miria.monitor.api.entity;

import java.util.Date;
import javax.persistence.*;

@Table(name = "tb_alert_rule")
public class AlertRule {
    /**
     * 主键id
     */
    @Id
    private Long id;

    /**
     * 名称
     */
    private String name;

    /**
     * 采集指标的表达式
     */
    private String metric;

    /**
     * 指标类型
     */
    @Column(name = "metric_type")
    private String metricType;

    /**
     * 表达式涵义，是增长率还是绝对值，或是其他类型，0代表增长率，1代表绝对值
     */
    @Column(name = "metric_meaning")
    private Byte metricMeaning;

    /**
     * 条件> = <
     */
    private String judgment;

    /**
     * 阈值
     */
    private String threshold;

    /**
     * 0 代表绝对值, 1代表百分比
     */
    @Column(name = "threshold_type")
    private Byte thresholdType;

    /**
     * 创建时间
     */
    @Column(name = "gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 获取主键id
     *
     * @return id - 主键id
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置主键id
     *
     * @param id 主键id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取名称
     *
     * @return name - 名称
     */
    public String getName() {
        return name;
    }

    /**
     * 设置名称
     *
     * @param name 名称
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * 获取采集指标的表达式
     *
     * @return metric - 采集指标的表达式
     */
    public String getMetric() {
        return metric;
    }

    /**
     * 设置采集指标的表达式
     *
     * @param metric 采集指标的表达式
     */
    public void setMetric(String metric) {
        this.metric = metric == null ? null : metric.trim();
    }

    /**
     * 获取指标类型
     *
     * @return metric_type - 指标类型
     */
    public String getMetricType() {
        return metricType;
    }

    /**
     * 设置指标类型
     *
     * @param metricType 指标类型
     */
    public void setMetricType(String metricType) {
        this.metricType = metricType == null ? null : metricType.trim();
    }

    /**
     * 获取表达式涵义，是增长率还是绝对值，或是其他类型，0代表增长率，1代表绝对值
     *
     * @return metric_meaning - 表达式涵义，是增长率还是绝对值，或是其他类型，0代表增长率，1代表绝对值
     */
    public Byte getMetricMeaning() {
        return metricMeaning;
    }

    /**
     * 设置表达式涵义，是增长率还是绝对值，或是其他类型，0代表增长率，1代表绝对值
     *
     * @param metricMeaning 表达式涵义，是增长率还是绝对值，或是其他类型，0代表增长率，1代表绝对值
     */
    public void setMetricMeaning(Byte metricMeaning) {
        this.metricMeaning = metricMeaning;
    }

    /**
     * 获取条件> = <
     *
     * @return judgment - 条件> = <
     */
    public String getJudgment() {
        return judgment;
    }

    /**
     * 设置条件> = <
     *
     * @param judgment 条件> = <
     */
    public void setJudgment(String judgment) {
        this.judgment = judgment == null ? null : judgment.trim();
    }

    /**
     * 获取阈值
     *
     * @return threshold - 阈值
     */
    public String getThreshold() {
        return threshold;
    }

    /**
     * 设置阈值
     *
     * @param threshold 阈值
     */
    public void setThreshold(String threshold) {
        this.threshold = threshold == null ? null : threshold.trim();
    }

    /**
     * 获取0 代表绝对值, 1代表百分比
     *
     * @return threshold_type - 0 代表绝对值, 1代表百分比
     */
    public Byte getThresholdType() {
        return thresholdType;
    }

    /**
     * 设置0 代表绝对值, 1代表百分比
     *
     * @param thresholdType 0 代表绝对值, 1代表百分比
     */
    public void setThresholdType(Byte thresholdType) {
        this.thresholdType = thresholdType;
    }

    /**
     * 获取创建时间
     *
     * @return gmt_create - 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置创建时间
     *
     * @param gmtCreate 创建时间
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * 获取修改时间
     *
     * @return gmt_modified - 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间
     *
     * @param gmtModified 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}