package cn.com.duiba.miria.monitor.api.entity;

import javax.persistence.*;
import java.util.Date;

@Table(name = "tb_graph")
public class Graph {
    /**
     * 主键id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 名称
     */
    private String name;

    /**
     * 类别，基础折线图等
     */
    private Byte type;

    /**
     * 该图展示的指标的类型
     */
    @Column(name = "metric_type")
    private String metricType;

    /**
     * 创建时间
     */
    @Column(name = "gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 获取主键id
     *
     * @return id - 主键id
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置主键id
     *
     * @param id 主键id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取名称
     *
     * @return name - 名称
     */
    public String getName() {
        return name;
    }

    /**
     * 设置名称
     *
     * @param name 名称
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * 获取类别，基础折线图等
     *
     * @return type - 类别，基础折线图等
     */
    public Byte getType() {
        return type;
    }

    /**
     * 设置类别，基础折线图等
     *
     * @param type 类别，基础折线图等
     */
    public void setType(Byte type) {
        this.type = type;
    }

    /**
     * 获取该图展示的指标的类型
     *
     * @return metric_type - 该图展示的指标的类型
     */
    public String getMetricType() {
        return metricType;
    }

    /**
     * 设置该图展示的指标的类型
     *
     * @param metricType 该图展示的指标的类型
     */
    public void setMetricType(String metricType) {
        this.metricType = metricType == null ? null : metricType.trim();
    }

    /**
     * 获取创建时间
     *
     * @return gmt_create - 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置创建时间
     *
     * @param gmtCreate 创建时间
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * 获取修改时间
     *
     * @return gmt_modified - 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间
     *
     * @param gmtModified 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}