package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.monitor.api.entity.AlertRule;
import cn.com.duiba.miria.monitor.api.param.AlertRuleParam;

import java.util.List;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface AlertRuleService {

    /**
     * 查询所有报警规则
     * @return 所有报警规则
     */
    List<AlertRule> listAll();

    /**
     * 新增报警规则
     * @param alertRuleParam 规则参数
     * @throws BizException 业务异常
     */
    void insert(AlertRuleParam alertRuleParam) throws BizException;

    /**
     * 更新报警规则
     * @param alertRuleParam 规则参数
     * @throws BizException 业务异常
     */
    void update(AlertRuleParam alertRuleParam) throws BizException;

    /**
     * 删除报警规则
     * @param id 根据id删除报警规则
     */
    void delete(Long id);

}
