package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.monitor.api.entity.AlertRule;
import cn.com.duiba.miria.monitor.api.param.AlertRuleParam;
import cn.com.duiba.miria.monitor.api.param.AlertRuleTemplateParam;
import cn.com.duiba.miria.monitor.api.vo.AlertRuleTemplateVO;

import java.util.List;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface AlertRuleTemplateService {

    /**
     * 查询所有报警模板
     * @return 所有报警模板
     */
    List<AlertRuleTemplateVO> listAll();

    /**
     * 新增报警规则
     * @param alertRuleTemplateParam 模板参数
     * @throws BizException 业务异常
     */
    void insert(AlertRuleTemplateParam alertRuleTemplateParam) throws BizException;

    /**
     * 更新报警规则
     * @param alertRuleTemplateParam 模板参数
     * @throws BizException 业务异常
     */
    void update(AlertRuleTemplateParam alertRuleTemplateParam) throws BizException;

    /**
     * 删除报警规则
     * @param id 根据id删除报警规则
     */
    void delete(Long id);

}
