package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.monitor.api.entity.AlarmConfig;
import cn.com.duiba.miria.monitor.api.enums.AlarmTypeEnum;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface AlarmConfigService {

    /**
     * 根据报警枚举类型查询对应的报警配置
     *
     * @param alarmTypeEnum 报警枚举类型
     * @return 报警配置
     */
    AlarmConfig getAlarmConfigByType(AlarmTypeEnum alarmTypeEnum);

    /**
     * 根据报警枚举类型更新对应的报警配置
     * @param alarmTypeEnum 报警枚举类型
     * @param alarmConfig 最新的报警配置
     */
    void updateAlarmConfigByType(AlarmTypeEnum alarmTypeEnum, AlarmConfig alarmConfig);

}
