package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.monitor.api.entity.DingTalk;
import cn.com.duiba.miria.monitor.api.param.DingTalkParam;

import java.util.List;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface DingTalkService {

    /**
     * 根据参数类查询钉钉机器人信息，支持分表
     *
     * @return 钉钉机器人信息
     */
    List<DingTalk> listDingTalk();

    /**
     * 新增钉钉机器人
     * @param dingTalkParam 新增的钉钉机器人
     * @throws BizException 业务异常
     */
    void addDingTalk(DingTalkParam dingTalkParam) throws BizException;

    /**
     * 根据参数中的id更新钉钉机器人
     * @param dingTalkParam 被更新的钉钉机器人
     */
    void updateDingTalk(DingTalkParam dingTalkParam);

    /**
     * 根据id删除钉钉机器人
     * @param id 钉钉机器人id
     */
    void deleteDingRobot(Long id);

}
