package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.monitor.api.param.TriggerTemplateParam;
import cn.com.duiba.miria.monitor.api.vo.TriggerTemplateVO;

import java.util.List;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface TriggerTemplateService {

    /**
     * 查询所有报警模板
     * @return 所有报警模板
     */
    List<TriggerTemplateVO> listAll();

    /**
     * 新增报警模板
     * @param triggerTemplateParam 模板参数
     * @throws BizException 业务异常
     */
    void insert(TriggerTemplateParam triggerTemplateParam) throws BizException;

    /**
     * 更新报警模板
     * @param triggerTemplateParam 模板参数
     * @throws BizException 业务异常
     */
    void update(TriggerTemplateParam triggerTemplateParam) throws BizException;

    /**
     * 删除报警模板
     * @param id 根据id删除报警模板
     */
    void delete(Long id);

}
