package cn.com.duiba.miria.monitor.api.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
* 告警采集规则
 * @author wrj
 */
@Data
@EqualsAndHashCode(of = {"appId", "metric"})
public class AlertCollectRule implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
    * id
    */
    private Long id;

    /**
    * 告警采集的应用Id
    */
    private Long appId;

    /**
    * 采集指标
    */
    private String metric;

    /**
     * 条件 > = <
     */
    private String judgment;

    /**
     * 阈值 具体的数值
     */
    private Float threshold;

    /**
     * 阈值单位 阈值的单位
     * 0 代表绝对值, 1代表百分比
     */
    private Integer thresholdType;

    /**
    * 告警分组ID
    */
    private Long alertGroupId;

    /**
     * 是否是默认配置
     */
    private Integer isDefault;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

}

