package cn.com.duiba.miria.monitor.api.entity;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

@Table(name = "tb_alert_history")
public class AlertHistory {
    /**
     * 主键id
     */
    @Id
    private Long id;

    /**
     * 应用名称
     */
    @Column(name = "app_name")
    private String appName;

    /**
     * pod名称
     */
    @Column(name = "pod_name")
    private String podName;

    /**
     * 触发器名称
     */
    @Column(name = "trigger_name")
    private String triggerName;

    /**
     * 指标当前值
     */
    @Column(name = "current_value")
    private String currentValue;

    /**
     * 阈值
     */
    private String threshold;

    /**
     * 宿主机cpu当前使用率
     */
    @Column(name = "host_cpu")
    private Byte hostCpu;

    /**
     * 宿主机memory当前使用率
     */
    @Column(name = "host_memory")
    private Byte hostMemory;

    /**
     * 0: 正在报警，1: 已恢复
     */
    private Boolean state;

    /**
     * 创建时间
     */
    @Column(name = "gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 主机名
     */
    @Column(name = "host_name")
    private String hostName;

    /**
     * 获取主键id
     *
     * @return id - 主键id
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置主键id
     *
     * @param id 主键id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取应用名称
     *
     * @return app_name - 应用名称
     */
    public String getAppName() {
        return appName;
    }

    /**
     * 设置应用名称
     *
     * @param appName 应用名称
     */
    public void setAppName(String appName) {
        this.appName = appName == null ? null : appName.trim();
    }

    /**
     * 获取pod名称
     *
     * @return pod_name - pod名称
     */
    public String getPodName() {
        return podName;
    }

    /**
     * 设置pod名称
     *
     * @param podName pod名称
     */
    public void setPodName(String podName) {
        this.podName = podName == null ? null : podName.trim();
    }

    /**
     * 获取触发器名称
     *
     * @return trigger_name - 触发器名称
     */
    public String getTriggerName() {
        return triggerName;
    }

    /**
     * 设置触发器名称
     *
     * @param triggerName 触发器名称
     */
    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName == null ? null : triggerName.trim();
    }

    /**
     * 获取指标当前值
     *
     * @return current_value - 指标当前值
     */
    public String getCurrentValue() {
        return currentValue;
    }

    /**
     * 设置指标当前值
     *
     * @param currentValue 指标当前值
     */
    public void setCurrentValue(String currentValue) {
        this.currentValue = currentValue == null ? null : currentValue.trim();
    }

    /**
     * 获取阈值
     *
     * @return threshold - 阈值
     */
    public String getThreshold() {
        return threshold;
    }

    /**
     * 设置阈值
     *
     * @param threshold 阈值
     */
    public void setThreshold(String threshold) {
        this.threshold = threshold == null ? null : threshold.trim();
    }

    /**
     * 获取宿主机cpu当前使用率
     *
     * @return host_cpu - 宿主机cpu当前使用率
     */
    public Byte getHostCpu() {
        return hostCpu;
    }

    /**
     * 设置宿主机cpu当前使用率
     *
     * @param hostCpu 宿主机cpu当前使用率
     */
    public void setHostCpu(Byte hostCpu) {
        this.hostCpu = hostCpu;
    }

    /**
     * 获取宿主机memory当前使用率
     *
     * @return host_memory - 宿主机memory当前使用率
     */
    public Byte getHostMemory() {
        return hostMemory;
    }

    /**
     * 设置宿主机memory当前使用率
     *
     * @param hostMemory 宿主机memory当前使用率
     */
    public void setHostMemory(Byte hostMemory) {
        this.hostMemory = hostMemory;
    }

    /**
     * 获取0: 正在报警，1: 已恢复
     *
     * @return state - 0: 正在报警，1: 已恢复
     */
    public Boolean getState() {
        return state;
    }

    /**
     * 设置0: 正在报警，1: 已恢复
     *
     * @param state 0: 正在报警，1: 已恢复
     */
    public void setState(Boolean state) {
        this.state = state;
    }

    /**
     * 获取创建时间
     *
     * @return gmt_create - 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置创建时间
     *
     * @param gmtCreate 创建时间
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * 获取修改时间
     *
     * @return gmt_modified - 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间
     *
     * @param gmtModified 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * 获取主机名
     *
     * @return host_name - 主机名
     */
    public String getHostName() {
        return hostName;
    }

    /**
     * 设置主机名
     *
     * @param hostName 主机名
     */
    public void setHostName(String hostName) {
        this.hostName = hostName == null ? null : hostName.trim();
    }
}