package cn.com.duiba.miria.monitor.api.entity;

import javax.persistence.*;
import java.util.Date;

@Table(name = "tb_metric_scale_config")
public class MetricScaleConfig {
    /**
     * 逻辑主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 应用id，当为null时代表全局默认配置
     */
    @Column(name = "app_id")
    private Long appId;

    /**
     * 扩缩容步长
     */
    private Integer step;

    /**
     * 最大副本数
     */
    @Column(name = "max_replica_num")
    private Integer maxReplicaNum;

    /**
     * 持续分钟数，比如当配置为3时，代表当指标处于异常持续3分钟后，进行扩容或缩容
     */
    private Integer duration;

    /**
     * 扩容所需达到的平均cpu使用率
     */
    @Column(name = "cpu_high_threshold")
    private Integer cpuHighThreshold;

    /**
     * 缩容所需达到的平均cpu使用率
     */
    @Column(name = "cpu_low_threshold")
    private Integer cpuLowThreshold;

    /**
     * 创建时间
     */
    @Column(name = "gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 获取逻辑主键
     *
     * @return id - 逻辑主键
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置逻辑主键
     *
     * @param id 逻辑主键
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取应用id，当为null时代表全局默认配置
     *
     * @return app_id - 应用id，当为null时代表全局默认配置
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * 设置应用id，当为null时代表全局默认配置
     *
     * @param appId 应用id，当为null时代表全局默认配置
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * 获取扩缩容步长
     *
     * @return step - 扩缩容步长
     */
    public Integer getStep() {
        return step;
    }

    /**
     * 设置扩缩容步长
     *
     * @param step 扩缩容步长
     */
    public void setStep(Integer step) {
        this.step = step;
    }

    /**
     * 获取最大副本数
     *
     * @return max_replica_num - 最大副本数
     */
    public Integer getMaxReplicaNum() {
        return maxReplicaNum;
    }

    /**
     * 设置最大副本数
     *
     * @param maxReplicaNum 最大副本数
     */
    public void setMaxReplicaNum(Integer maxReplicaNum) {
        this.maxReplicaNum = maxReplicaNum;
    }

    /**
     * 获取持续分钟数，比如当配置为3时，代表当指标处于异常持续3分钟后，进行扩容或缩容
     *
     * @return duration - 持续分钟数，比如当配置为3时，代表当指标处于异常持续3分钟后，进行扩容或缩容
     */
    public Integer getDuration() {
        return duration;
    }

    /**
     * 设置持续分钟数，比如当配置为3时，代表当指标处于异常持续3分钟后，进行扩容或缩容
     *
     * @param duration 持续分钟数，比如当配置为3时，代表当指标处于异常持续3分钟后，进行扩容或缩容
     */
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    /**
     * 获取扩容所需达到的平均cpu使用率
     *
     * @return cpu_high_threshold - 扩容所需达到的平均cpu使用率
     */
    public Integer getCpuHighThreshold() {
        return cpuHighThreshold;
    }

    /**
     * 设置扩容所需达到的平均cpu使用率
     *
     * @param cpuHighThreshold 扩容所需达到的平均cpu使用率
     */
    public void setCpuHighThreshold(Integer cpuHighThreshold) {
        this.cpuHighThreshold = cpuHighThreshold;
    }

    /**
     * 获取缩容所需达到的平均cpu使用率
     *
     * @return cpu_low_threshold - 缩容所需达到的平均cpu使用率
     */
    public Integer getCpuLowThreshold() {
        return cpuLowThreshold;
    }

    /**
     * 设置缩容所需达到的平均cpu使用率
     *
     * @param cpuLowThreshold 缩容所需达到的平均cpu使用率
     */
    public void setCpuLowThreshold(Integer cpuLowThreshold) {
        this.cpuLowThreshold = cpuLowThreshold;
    }

    /**
     * 获取创建时间
     *
     * @return gmt_create - 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置创建时间
     *
     * @param gmtCreate 创建时间
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * 获取修改时间
     *
     * @return gmt_modified - 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间
     *
     * @param gmtModified 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}