package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.monitor.api.param.InstanceInfo;
import cn.com.duiba.miria.monitor.api.param.InstanceParam;

import java.util.List;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface DeleteInstanceService {

    /**
     * 删除指定id的机器
     *
     * @param params 机器id
     */
    void deleteInstanceByIds(List<InstanceParam> params);

    /**
     * 查询建议被删除的实例列表
     *
     * @return 建议被删除的实例列表
     */
    List<InstanceInfo> queryCandidateInstances();

}
